﻿using SnapsLibrary;

using Newtonsoft.Json;

class Ch10_07_PizzaPicker
{
    class PizzaDetails
    {
        public int CheeseAndTomatoCount = 0;
        public int pepperoniCount = 0;
        public int chickenCount = 0;
        public int vegetarianCount = 0;
    }

    public void StartProgram()
    {
        string SAVE_NAME = "pizzaChoice.json";

        PizzaDetails pizzaDetails;

        string json = SnapsEngine.FetchStringFromRoamingStorage(SAVE_NAME);

        if (json == null)
        {
            // Nie ma żadnych zapisanych zamówień pizzy - tworzenie pustego magazynu
            pizzaDetails = new PizzaDetails();
        }
        else
        {
            // Odczyt zamówień pizzy z poprzedniego uruchomienia
            pizzaDetails = JsonConvert.DeserializeObject<PizzaDetails>(json);
        }

        SnapsEngine.SetTitleString("Wybierz pizze");

        // repeatedly ask for pizza selections
        while (true)
        {
            string toppingChoice = SnapsEngine.SelectFrom5Buttons("Ser i pomidory",
                                                            "Pepperoni",
                                                            "Kurczak", "Wegetariańska",
                                                            "Wyświetl podsumowanie");

            if (toppingChoice == "Ser i pomidory")
                pizzaDetails.CheeseAndTomatoCount = pizzaDetails.CheeseAndTomatoCount + 1;

            if (toppingChoice == "Pepperoni")
                pizzaDetails.pepperoniCount = pizzaDetails.pepperoniCount + 1;

            if (toppingChoice == "Kurczak")
                pizzaDetails.chickenCount = pizzaDetails.chickenCount + 1;

            if (toppingChoice == "Wegetariańska")
                pizzaDetails.vegetarianCount = pizzaDetails.vegetarianCount + 1;

            if (toppingChoice == "Wyświetl podsumowanie")
            {
                string result = "Podsumowanie zamówienia:\n" +
                    pizzaDetails.CheeseAndTomatoCount.ToString() + " Ser i pomidory\n" +
                    pizzaDetails.pepperoniCount.ToString() + " Pepperoni\n" +
                    pizzaDetails.chickenCount.ToString() + " Kurczak\n" +
                    pizzaDetails.vegetarianCount.ToString() + " Wegerariańska\n";

                SnapsEngine.DisplayString(result);

                string reply = SnapsEngine.SelectFrom2Buttons("Zrobione", "Resetuj");
                if (reply == "Resetuj")
                {
                    pizzaDetails.CheeseAndTomatoCount = 0;
                    pizzaDetails.pepperoniCount = 0;
                    pizzaDetails.chickenCount = 0;
                    pizzaDetails.vegetarianCount = 0;
                }
                // clear the total display from the screen
                SnapsEngine.DisplayString("");
            }

json = JsonConvert.SerializeObject(pizzaDetails);

SnapsEngine.SaveStringToRoamingStorage(itemName: SAVE_NAME, itemValue: json);
        }
    }
}